import numpy as np
from matplotlib import pyplot as plt
import csv
from collections import Counter
# bar chart of most popular programming languages

plt.style.use("fivethirtyeight")

# read the date from csv file using standard library
with open('data.csv') as csv_file:
    # read data automatically into dictionary
    csv_reader = csv.DictReader(csv_file)
    
    # print the first row od result
    # row = next(csv_reader)
    # print(row)
    # print(row["LanguagesWorkedWith"].split(";"))
    
    # fix the data by using a dict to count the occurences of languages
    # easier way to do this is using counters
    language_counter = Counter()
    for row in csv_reader:
        language_counter.update(row["LanguagesWorkedWith"].split(";"))
        
# all languages
# print(language_counter)

# print most common 15 responses
# list of tupples (language, no_of_responses)
# print(language_counter.most_common(15))

# split the tupples 
languages = []
popularity = []
for item in language_counter.most_common(15):
    languages.append(item[0])
    popularity.append(item[1])
    
# using this in one line
# zip + unpack
    
# print(languages)
# print(popularity)

# plotting horizontal bar charts
plt.barh(languages, popularity)

plt.title("Most popular programming languages survey")
# swap labels for horizontal
plt.ylabel("Language")
plt.xlabel("Numer of users in the survey")

plt.tight_layout()
plt.show()